 ; Ŀ
 ;   Bock - Text/Attribute/Attdef clouder.                                 
 ;   Copyright 1995, 1997, 2002, 2003, 2010 by Rocket Software Ltd.        
 ;   The phrase "Amaze your friends" doesn't usually imply any actual      
 ;   utility.                                                              
 ; 
 (DEFUN C:BOCK (/ *error* cm cron lenin marx chacha segtst cx plinth blip esav
                                  enam typ entt mxlst xmax xmin ymax ymin pl)
 ; Ŀ
 ;   Try to load Misps.lsp, which contains the subroutines for scaling     
 ;   differently in model and paper space.                                 
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Functions follow, all are local so as to avoid conflicts with other   
 ;   programs.  * This is unusual so pay attention. *                      
 ; 

 ; Ŀ
 ;   Redefine the error handler.                                           
 ; 
 (DEFUN *ERROR* (shk)
  (if clay (setvar "clayer" clay))
  (if pwid (setvar "plinewid" pwid))
  (if blip (setvar "blipmode" blip))
  (if plinth (setvar "plinetype" plinth))
 (princ))
 ; Ŀ
 ;   Local error handler end.                                              
 ; 

 ; Ŀ
 ;   CM - make a pline into a cloud.                                       
 ; 
 (DEFUN CM (pl / bulge blip dimscl bapt pa plist p0 p1 pl seg nname pb angg
                                                         dist pta side nn)
  (setq bulge 0.9)
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Ŀ
 ;   Establish a test point beside the first segment.                      
 ; 
  (setq seg (entget (setq nname (entnext pl))))            ; first vertex
  (setq pa (cdr (assoc 10 seg)))                           ; save location
  (setq seg (entget (entnext nname)))                      ; second vertex
  (setq pb (cdr (assoc 10 seg)))                           ; save location
  (setq angg (angle pa pb))                                ; segment angle
  (setq dist (distance pa pb))                             ; segment length
  (setq pta (polar pa angg (/ dist 2)))                    ; midpoint
  (setq pta (polar pta (+ angg (/ pi 2)) (/ dist 100)))    ; test point
  (setq side (cx pl pta))                                  ; outside = T
  (if side (setq bulge (* bulge -1)))                      ; t = reverse bulges
 ; Ŀ
 ;   Now insert extra vertices if any of the existing ones are too far     
 ;   apart.                                                                
 ; 
  (chacha pl)
  (setq pl (entlast))                                      ; get pline ename
 ; Ŀ
 ;   Apply the bulges to the segments.                                     
 ; 
  (setq nname pl)                                          ; save pline ename
  (setq nn (entget pl))                                    ; same entity
  (while (/= (cdr (assoc 0 nn)) "SEQEND")                  ; for each vertex
         (entmod (subst (cons 42 bulge) (assoc 42 nn) nn)) ; apply bulge
         (setq nn (entget (setq pl (entnext pl)))))        ; next vertex
  (entupd nname)                                           ; regen polyline
 (princ))
 ; Ŀ
 ;   Cm end.                                                               
 ; 

 ; Ŀ
 ;   Cron - returns the corners of the entity whose ename is passed as     
 ;   the sole argument.                                                    
 ; 
 (DEFUN CRON (enam / dimsc aa bb rota cc dd bheigt bwidth llangg lldist xmax
                                                  xmin ymax ymin ll ul lr ur)
  (if misps
      (setq dimsc (misps))
      (setq dimsc (getvar "dimscale")))
  (setq offdis (* 1.25 dimsc))
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assumining that the  
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
 ; Ŀ
 ;   Extract the real corner points of the text.                           
 ; 
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   Find the maximum and minimum X and Y points.  These may not be the    
 ;   same as the corners of the text box, since the text may be rotated.   
 ; 
  (setq xmax (max (car ul) (car ll) (car ur) (car lr)))
  (setq xmin (min (car ul) (car ll) (car ur) (car lr)))
  (setq ymax (max (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq ymin (min (cadr ul) (cadr ll) (cadr ur) (cadr lr)))
  (setq xmax (+ xmax offdis))
  (setq xmin (- xmin offdis))
  (setq ymax (+ ymax offdis))
  (setq ymin (- ymin offdis))
 ; Ŀ
 ;   And return the max and min x and y list.                              
 ; 
 (list xmax xmin ymax ymin))
 ; Ŀ
 ;   Cron end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Lenin - returns a list of points between two endpoints.    
 ;   Takes three arguments - two endpoints and a maximum distance to       
 ;   allow between points.                                                 
 ; 
 (DEFUN LENIN (pa pb maxd / angg dist ptlis)
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
  (setq angg (angle pa pb))
  (setq dist 1)
  (while (> (setq dist1 (distance pa pb)) maxd)
         (setq dist (* dimscl (marx maxd)))
         (if (> dist1 dist)                   ; if doesn't overshoot
             (setq pa (polar pa angg dist))   ; pa moves by dist from marx
             (setq pa pb))                    ; else moves to pb: end subr
         (setq ptlis (append ptlis (list pa))))
 ptlis)
 ; Ŀ
 ;   Lenin end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Marx - pseudo-random number generator.                     
 ;   Takes one argument - the maximum number to return.                    
 ;   Returns a real between the maximum and (currently) 0.45 thereof.      
 ; 
 (DEFUN MARX (maxi /)
  (setq maxi 9)             ; force for arc length scaling
  (setq dists (list 0.35 0.1 0.45 0.35 0.25 0.15 0.35 0.125 0.37 0.45 0.25
                    0.1 0.35 0.35 0.1 0.2 0.175 0.14 0.27 0.32 0.40 0.35
                    0.265 0.43 0.25 0.08 0.36 0.425 0.23 0.1 0.38 0.38
                    0.25 0.37 0.24 0.45 0.16 0.1 0.36 0.22 0.30 0.20 0.29))
  (cond ((/= (type opops) 'int)
         (setq opops 0))
        ((> opops (- (length dists) 2))
         (setq opops 0))
        (t (setq opops (1+ opops))))
 (* maxi (nth opops dists)))
 ; Ŀ
 ;   Marx end.                                                             
 ; 

 ; Ŀ
 ;   ChaCha - redraw a polyline so that no segment is over a set length.   
 ; 
 (DEFUN CHACHA (enam / dimscl maxd esav entt pasav pa pb ptlis ovlst)
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
  (setq maxd (* 2 dimscl))             ; maximum polyline arc length
  (setq esav enam)
  (while (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam))))))
             "SEQEND")
         (if pa (setq pb pa))
         (setq pa (cdr (assoc 10 entt)))
         (if (null pasav) (setq pasav pa))
         (if (and pa pb)
             (setq ptlis (lenin pb pa maxd))
             (setq ptlis ()))
         (if ptlis
             (setq ptlis (cons pb ptlis))
             (if pb (setq ptlis (list pb))))
         (if ptlis (setq ovlst (append ovlst ptlis))))
  (setq ptlis (lenin pa pasav maxd))
  (if ptlis
      (setq ptlis (cons pa ptlis))
      (if pa (setq ptlis (list pa))))
  (if ptlis (setq ovlst (append ovlst ptlis)))
  (command "erase" esav "")
  (command "pline")
  (while (setq pa (car ovlst))
         (setq ovlst (cdr ovlst))
         (command pa))
  (command "c")
 (princ))
 ; Ŀ
 ;   ChaCha end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Segtst - see if a polyline segment intersects a line       
 ;   drawn from a point.  Takes the point and segment ends as arguments    
 ;   and returns the intersection point (if any).                          
 ;   The line must be considered to be of infinite length so that it can   
 ;   hit any segment, but the intersection must be on the segment itself   
 ;   so that all tests of nonparallel lines don't produce an intersection. 
 ;   Find the infinite length intersection, measure the distance between   
 ;   that and the start point, make the line that length and do an onseg   
 ;   test.                                                                 
 ; 
 (DEFUN SEGTST (pa segst segend / pb intrs dist)
  (setq pb (polar pa 0 100))
  (setq intrs (inters pa pb segst segend ()))
  (if intrs
     (progn
          (setq dist (1+ (distance pa intrs)))
          (setq pb (polar pa 0 dist))
          (setq intrs (inters pa pb segst segend))))
 intrs)
 ; Ŀ
 ;   Segtst end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine CX - decide whether a point is inside or outside a pline.  
 ;   Takes the polyline ename and the test point as arguments, returns a   
 ;   string stating where it was.                                          
 ; 
 (DEFUN CX (pl pta / ints nn nname pasav pa intpt intlst pc)
 ; Ŀ
 ;   Have to check each segment to see if the test line intersects it,     
 ;   and keep a tally of the number of intersections.                      
 ;   A line exactly crossing a vertex will return an intersection for       
 ;   both segments, so keep an intersection list and ignore duplicates.    
 ; 
  (setq ints 0)
  (setq nn (entget (setq nname (entnext pl))))             ; first vertex
  (setq pasav (cdr (assoc 10 nn)))                         ; save location
  (while (/= (cdr (assoc 0 nn)) "SEQEND")
         (setq pa (cdr (assoc 10 nn)))
         (if (and pa pc (setq intpt (segtst pta pa pc)))   ; call inters finder
             (progn
                  (if (not (member intpt intlst))
                      (progn
                           (setq ints (1+ ints))
                           (setq intlst (cons intpt intlst))))))
         (setq pc pa)
         (setq nn (entget (setq nname (entnext nname)))))  ; next vertex
 ; Ŀ
 ;   Check the segment between the last vertex and the start point.        
 ; 
  (if (and pasav pc)
      (if (segtst pta pasav pc)
          (setq ints (1+ ints))))
 ; Ŀ
 ;   If there are 0 or an odd number of intersections the point is         
 ;   outside the polyline (T), otherwise it is inside ().                  
 ; 
 (if (= (/ ints 2) (/ ints 2.0)) T ()))
 ; Ŀ
 ;   CX end.                                                               
 ; 

 ; Ŀ
 ;   Bock - the headless body of the program.                              
 ; 
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq plinth (getvar "plinetype"))
  (setvar "plinetype" 0)
; (if (= 0 (getvar "dimscale")) (setvar "dimscale" 1))
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Save the current layer name, make Revision the new current one.       
 ; 
  (setq clay (getvar "clayer"))
  (if (tblsearch "layer" "revise")
      (setvar "clayer" "revise")
      (command "layer" "m" "revise" "c" "5" "" ""))
  (setq pwid (getvar "plinewid"))
;  (setvar "plinewid" (* 0.25 (getvar "dimscale")))
  (setvar "plinewid" 0)
 ; Ŀ
 ;   Get a selection set of text and blocks with attributes.               
 ; 
  (write-line "Select blocks, text, attdefs, etc.: ")
  (setq ss (ssget '((-4 . "<or")
                      (-4 . "<and")
                        (0 . "insert")
                        (66 . 1)
                      (-4 . "and>")
                      (0 . "text")
                      (0 . "attdef")
                    (-4 . "or>"))))
  (setq num 0)
 ; Ŀ
 ;   Process selection set.                                                
 ; 
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq typ (cdr (assoc 0 (entget enam))))
         (if (= typ "INSERT")
             (while (/= (setq typ (cdr (assoc 0 (setq entt (entget
                                                (setq enam (entnext enam)))))))
                        "SEQEND")
                    (if (and (= typ "ATTRIB")
                             (/= (cdr (assoc 1 entt)) "")
                             (/= (cdr (assoc 1 entt)) " "))
                        (progn
                             (setq mxlst (cron enam))
                             (if xmax
                                 (setq xmax (max xmax (car mxlst)))
                                 (setq xmax (car mxlst)))
                             (if xmin
                                 (setq xmin (min xmin (cadr mxlst)))
                                 (setq xmin (cadr mxlst)))
                             (if ymax
                                 (setq ymax (max ymax (caddr mxlst)))
                                 (setq ymax (caddr mxlst)))
                             (if ymin
                                 (setq ymin (min ymin (cadddr mxlst)))
                                 (setq ymin (cadddr mxlst)))))))
         (if (or (= typ "TEXT") (= typ "ATTDEF"))
             (progn
                  (setq mxlst (cron enam))
                  (if xmax
                      (setq xmax (max xmax (car mxlst)))
                      (setq xmax (car mxlst)))
                  (if xmin
                      (setq xmin (min xmin (cadr mxlst)))
                      (setq xmin (cadr mxlst)))
                  (if ymax
                      (setq ymax (max ymax (caddr mxlst)))
                      (setq ymax (caddr mxlst)))
                  (if ymin
                      (setq ymin (min ymin (cadddr mxlst)))
                      (setq ymin (cadddr mxlst))))))
 ; Ŀ
 ;   Now draw the polyline around the outer extent points.                 
 ; 
  (command ".pline")
  (command (list xmax ymax) (list xmin ymax))
  (command (list xmin ymax) (list xmin ymin))
  (command (list xmin ymin) (list xmax ymin))
  (command (list xmax ymin) (list xmax ymax))
  (command "c")                                            ; close polyline
  (setq pl (entlast))                                      ; Get pline ename
 ; Ŀ
 ;   Make the polyline into a cloud.                                       
 ; 
  (cm pl)
 ; Ŀ
 ;   Reset and end.                                                        
 ; 
  (*error* "")
 (princ))